<?php

namespace RtRasel\LaravelInstaller\Controllers;

use Illuminate\Routing\Controller;
use RtRasel\LaravelInstaller\Helpers\DatabaseManager;

class DatabaseController extends Controller
{
    /**
     * @var DatabaseManager
     */
    private $databaseManager;

    /**
     * @param  DatabaseManager  $databaseManager
     */
    public function __construct(DatabaseManager $databaseManager)
    {
        $this->databaseManager = $databaseManager;
    }

    /**
     * Migrate and seed the database.
     *
     * @return \Illuminate\View\View
     */
    public function database()
    {
        $response = $this->databaseManager->migrateAndSeed();
        if ($response['status'] === 'error') {
            return redirect()->route('LaravelInstaller::environment')->withInput()->withErrors([
                'migration_error' => __($response['message']),
            ]);
        }

        return redirect()->route('LaravelInstaller::final');
    }
}
